ON ERROR RESUME NEXT

Const HKEY_LOCAL_MACHINE = &H80000002
Const releaseIdPath = "SOFTWARE\Microsoft\Windows NT\CurrentVersion"

strComputer = "."
releaseId = "N/A"

Set objWMIService = GetObject("winmgmts:{impersonationLevel=impersonate}!\\" & strComputer & "\root\cimv2")
Set osInfoRes = objWMIService.ExecQuery("SELECT * FROM Win32_OperatingSystem")

If Err.Number <> 0 Then ShowError("Query Error:")

' https://docs.microsoft.com/en-us/previous-versions/windows/desktop/regprov/stdregprov
Set oReg = GetObject("winmgmts:{impersonationLevel=impersonate}!\\" & strComputer & "\root\default:StdRegProv")
oReg.GetStringValue HKEY_LOCAL_MACHINE, releaseIdPath, "ReleaseId", releaseId

If Err.Number <> 0 Then ShowError("Registry Error:")

DisplayResults osInfoRes.ItemIndex(0), releaseId

Sub DisplayResults(osInfo, releaseId)

    ' https://docs.microsoft.com/en-us/windows/win32/cimwin32prov/win32-operatingsystem

    caption = Replace(osInfo.Caption, "Microsoft ", "")
    SafeEcho caption & " v" & releaseId & " (" & osInfo.Version & " " & osInfo.OSArchitecture & ")"

End Sub

' Support both wscript/cscript and BGInfo
Sub SafeEcho(message)
	ON ERROR RESUME NEXT
	WScript.Echo message
	Echo message
	Err.Clear
End Sub

Sub ShowError(strMessage)
	num = Err.Number
	src = Err.Source
	desc = Err.Description

    SafeEcho strMessage
    SafeEcho num & " Source: " & src & " Desc: " & desc
    Err.Clear
End Sub