ON ERROR RESUME NEXT

includeInterfaces = Array()
excludeInterfaces = Array("Hyper-V Virtual Ethernet Adapter%", "Npcap Loopback Adapter")

strComputer = "."
descriptionIncMatch = ""
descriptionExcMatch = ""
descriptionIncFiller = "Description = Description" ' Always true
descriptionExcFiller = "Description = Description" ' Always true

For Each interface in includeInterfaces
    descriptionIncMatch = descriptionIncMatch & " OR Description LIKE '" & interface & "'"
    descriptionIncFiller = "Description != Description" ' Always false
Next
For Each interface in excludeInterfaces
    descriptionExcMatch = descriptionExcMatch & " AND NOT Description LIKE '" & interface & "'"
Next

query = "SELECT * FROM Win32_NetworkAdapterConfiguration WHERE IPEnabled = 'True'" _
    & " AND (" & descriptionIncFiller & descriptionIncMatch & ")" _
    & " AND (" & descriptionExcFiller & descriptionExcMatch & ")"

Set objWMIService = GetObject("winmgmts:{impersonationLevel=impersonate}!\\" & strComputer & "\root\cimv2")
Set adapterInfo = objWMIService.ExecQuery(query)

If Err.Number <> 0 Then
    ShowError("Query Error:")
Else
    DisplayResults(adapterInfo)
End If

Sub DisplayResults(results)

    ' See https://docs.microsoft.com/en-us/windows/win32/cimwin32prov/win32-networkadapterconfiguration for fields

    For Each objIPv4 in results
        SafeEcho objIPv4.Description & ":"
       

        If objIPv4.DHCPEnabled Then
            SafeEcho "DHCP:              " & objIPv4.DHCPServer
        Else
            SafeEcho "DHCP:                   Disabled"
        End If

        ' Show all IPv4 addresses
        For i=LBound(objIPv4.IPAddress) to UBound(objIPv4.IPAddress)
            If IsIpv4(objIPv4.IPAddress(i)) Then
               SafeEcho "IP:                           " & objIPv4.IPAddress(i)
               SafeEcho "Subnet:                 " & objIPv4.IPSubnet(i)

               If IsArray(objIPv4.DefaultIpGateway) Then
                    SafeEcho "Gateway:              " & objIPv4.DefaultIpGateway(i)
               End If

            End If
        Next


        If IsArray(objIPv4.DNSServerSearchOrder) Then
            SafeEcho ""
            SafeEcho "DNS Server 1 :    " & objIPv4.DNSServerSearchOrder(LBound(objIPv4.DNSServerSearchOrder))

            For i=LBound(objIPv4.DNSServerSearchOrder) + 1 to UBound(objIPv4.DNSServerSearchOrder)
                SafeEcho "DNS Server 2 :     " & objIPv4.DNSServerSearchOrder(i)
		SafeEcho ""
            Next
        End If
    Next

    If Err.Number <> 0 Then
        ShowError("Error:")
        Exit Sub
    End If

End Sub

Function IsIpv4(address)
    ' Assume all IPv6 addresses have a :
    IsIpv4 = (InStr(address,":") = 0)
End Function

' Support both wscript/cscript and BGInfo
Sub SafeEcho(message)
    ON ERROR RESUME NEXT
    WScript.Echo message
    Echo message
    Err.Clear
End Sub

Sub ShowError(strMessage)
    num = Err.Number
    src = Err.Source
    desc = Err.Description

    SafeEcho strMessage
    SafeEcho num & " Source: " & src & " Desc: " & desc
    Err.Clear
End Sub